/*
 * Decompiled with CFR 0.152.
 */
package com.sothawo.mapjfx;

import com.sothawo.mapjfx.Coordinate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

public final class Extent {
    private final Coordinate min;
    private final Coordinate max;

    public static Extent forCoordinates(Coordinate ... coordinates) {
        return Extent.forCoordinates(Arrays.asList((Object[])Objects.requireNonNull(coordinates)));
    }

    public static Extent forCoordinates(Collection<? extends Coordinate> coordinates) {
        Objects.requireNonNull(coordinates);
        if (coordinates.size() < 2) {
            throw new IllegalArgumentException();
        }
        double minLatitude = Double.MAX_VALUE;
        double maxLatitude = -1.7976931348623157E308;
        double minLongitude = Double.MAX_VALUE;
        double maxLongitude = -1.7976931348623157E308;
        for (Coordinate coordinate : coordinates) {
            minLatitude = Math.min(minLatitude, coordinate.getLatitude());
            maxLatitude = Math.max(maxLatitude, coordinate.getLatitude());
            minLongitude = Math.min(minLongitude, coordinate.getLongitude());
            maxLongitude = Math.max(maxLongitude, coordinate.getLongitude());
        }
        return new Extent(new Coordinate(minLatitude, minLongitude), new Coordinate(maxLatitude, maxLongitude));
    }

    private Extent(Coordinate min, Coordinate max) {
        this.min = Objects.requireNonNull(min);
        this.max = Objects.requireNonNull(max);
    }

    public Coordinate getMax() {
        return this.max;
    }

    public Coordinate getMin() {
        return this.min;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Extent extent = (Extent)o;
        return this.max.equals(extent.max) && this.min.equals(extent.min);
    }

    public int hashCode() {
        int result = this.min.hashCode();
        result = 31 * result + this.max.hashCode();
        return result;
    }

    public String toString() {
        return "Extent{min=" + this.min + ", max=" + this.max + '}';
    }
}

